﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class ImageViewer


    ' 此方法重载默认的 Show 方法，以便能够
    ' 传递参数，根据 frmMain 上 GetHttpStream() 返回的流
    ' 来显示图像。
    Public Overloads Sub Show(ByVal strImgSrc As String)
        Dim frmMain As New MainForm()

        With picImage
            Try
                ' 将 PictureBox Image 属性设置为
                ' 由 Http 响应流生成的图像。
                .Image = Image.FromStream(frmMain.GetHttpStream(strImgSrc))
            Catch exp As Exception
                MsgBox(exp.ToString, MsgBoxStyle.Critical, Me.Text)
            End Try

            .SizeMode = PictureBoxSizeMode.CenterImage
        End With

        lblImageFilename.Text = strImgSrc

        Me.Show()
        Application.DoEvents()
    End Sub

    ' 处理“Close”（关闭）按钮的 Click 事件。隐藏窗体。
    Private Sub btnClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClose.Click
        Me.Hide()
    End Sub

End Class